//%attributes = {}
// Method: ldcap_ CALC_ARR_FREE_CACLULATE
// 2009.03.26-00:04:47 / Pasi Mankinen
// © Copyright 2009 Manage Applications
// Purpose: calculate capacity free arrays based on load
// 
// fix also: ldcap_FREE_CACLULATE !!!
// ------------------------------------------------------------
If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStart; Current method name:C684)
End if 

C_TEXT:C284($1; $ld_tLoadGroup; $ld_tErr)  //load group
C_LONGINT:C283($2; $ld_lExcludeWorkIndex; $3; $ld_lCalcLoadFromCriticalDate; $ldcap_lCapArrSize)
C_LONGINT:C283($ld_lWorkIndex; $ld_lWorkCount; $ld_lCapIndex; $ld_lCapFirst)
C_REAL:C285($ld_rWorkTimeTotal; $ld_rWorkTimeRemaining; $ld_rWorkStart; $ld_rPhaseTimeRemaining)
C_REAL:C285($ld_rCapacityStartTime; $ld_rMovedDateTime)
C_REAL:C285($ld_rDateRemainingCap; $ld_rMultiplier; $ld_rWorkTimeInPhaseMultiplier)
C_DATE:C307($ld_dWorkStartDate; $ld_dCapacityStartDate)
C_TIME:C306($ld_hWorkStartTime; $ld_hCapacityStartTime)

COMPILER_ld_
//COMPILER_ld_cap_   `load capasity
//COMPILER_ldf_   `fine load
// COMPILER_ld_calc_arr 
$ld_tLoadGroup:=$1
$ld_lExcludeWorkIndex:=$2  //negative = exclude abs(this) and all the rest `PM: 2009-04-01
$ld_lCalcLoadFromCriticalDate:=$3

ldcap_ ARR_LOAD($ld_tLoadGroup)

$ldcap_lCapArrSize:=ldcap_ CapacityArrSize
If ($ldcap_lCapArrSize>0)
	$ld_dCapacityStartDate:=ldcap_dCapacityStartDate
	$ld_hCapacityStartTime:=ldcap_hCapacityStartTime
	
	//AK: 2004-08-13
	If ($ld_dCapacityStartDate=!00-00-00!)
		$ld_dCapacityStartDate:=_date Current(kTrue)
		$ld_hCapacityStartTime:=_time Current(kTrue)
	End if 
	
	$ld_lCapFirst:=ldcap_IndexFirst($ld_tLoadGroup; $ld_dCapacityStartDate)
	
	If ($ld_lCapFirst<1)
		$ld_lCapFirst:=1  //PM: 2006-10-25, prevent negative capacity
	End if 
	
	For ($ld_lCapIndex; 0; $ld_lCapFirst)  //zero all capacity before today, start from ZERO!
		ldcap_arCurrentFree{$ld_lCapIndex}:=0
		ldcap_arCumulativeFree{$ld_lCapIndex}:=0
	End for 
	
	For ($ld_lCapIndex; $ld_lCapFirst; $ldcap_lCapArrSize)  //zero current from start to end of array
		ldcap_arCurrentFree{$ld_lCapIndex}:=ldcap_arCapacity{$ld_lCapIndex}
	End for 
	
	// remove elapsed time from first capacity
	$ld_rCapacityStartTime:=_dt ToReal($ld_dCapacityStartDate; $ld_hCapacityStartTime)
	Case of 
		: ($ld_rCapacityStartTime>ldcap_arEnd{$ld_lCapFirst})
			ldcap_arCurrentFree{$ld_lCapFirst}:=0
		: ($ld_rCapacityStartTime>ldcap_arStart{$ld_lCapFirst})
			$ld_rDateRemainingCap:=_dt Difference($ld_rCapacityStartTime; ldcap_arStart{$ld_lCapFirst})
			$ld_rMultiplier:=ldcap_PhaseTimeMultiplier($ld_lCapFirst; 0; $ld_tLoadGroup)  //PM: 2009-06-11, added multiplier
			$ld_rDateRemainingCap:=$ld_rDateRemainingCap*$ld_rMultiplier
			ldcap_arCurrentFree{$ld_lCapFirst}:=ldcap_arCurrentFree{$ld_lCapFirst}-$ld_rDateRemainingCap
	End case 
	
	$ld_lWorkCount:=Size of array:C274(ld_calc_adStart_Date)
	If ($ld_lExcludeWorkIndex<0)  //stop calculating to exclude work!
		$ld_lExcludeWorkIndex:=Abs:C99($ld_lExcludeWorkIndex)
		$ld_lWorkCount:=$ld_lExcludeWorkIndex-1
	End if 
	
	For ($ld_lWorkIndex; 1; $ld_lWorkCount)
		
		Case of 
			: ($ld_lWorkIndex=$ld_lExcludeWorkIndex)
				IDLE:C311
			: (ld_calc_asWork_Load_Group_id{$ld_lWorkIndex}#$ld_tLoadGroup)  //PM: 2009-03-31
				IDLE:C311
			Else 
				$ldwp_lStopped:=kFalse
				
				If (False:C215)  //PM: 2009-03-26: ld_wo_ arrays are not used and not loaded
					$ldwp_lWoIndex:=Find in array:C230(ld_wo_atProduction_Lot; ld_calc_asProduction_Lot{$ld_lWorkIndex})
					If ($ldwp_lWoIndex>0)
						If (ld_wo_atState{$ldwp_lWoIndex}=<>ld_tStateStopped)  //was: <>load_sState_NotLoaded
							$ldwp_lStopped:=kTrue
						End if 
					End if 
				End if 
				
				// change also: ld_WORK_ARR_CUMUL_FREE_CALC
				Case of 
					: ($ldwp_lStopped=kTrue)
						IDLE:C311  //do not calculate stopped from capacity        
					: (ld_calc_afSubcontract{$ld_lWorkIndex})
						IDLE:C311  //do not calculate subcontrats from capacity
					: (ld_calc_asWork_Phase_State{$ld_lWorkIndex}=<>ld_tStateStopped)  //="PE"
						IDLE:C311  //do not calculate finished works from capacity        
					: (ld_calc_asWork_Phase_State{$ld_lWorkIndex}=<>ld_tStateFinished)  //="LT"
						IDLE:C311  //do not calculate finished works from capacity
					: (ld_calc_asWork_Phase_State{$ld_lWorkIndex}=<>ld_tStateCanceled)  //="PE"
						IDLE:C311  //do not calculate cancelled works from capacity        
					Else 
						
						If ($ld_lCalcLoadFromCriticalDate=kFalse)
							//used in forward free calculation
							$ld_dWorkStartDate:=ld_calc_adStart_Date{$ld_lWorkIndex}
							$ld_hWorkStartTime:=ld_calc_ahStart_Time{$ld_lWorkIndex}
						Else 
							If (ld_calc_adPhaseCriticalDate{$ld_lWorkIndex}=!00-00-00!)
								_err MESSAGE(_lang Current("Phase critical date is zero for")+": "+ld_calc_asProduction_Lot__work_{$ld_lWorkIndex}+", "+ld_calc_atName{$ld_lWorkIndex}+"."+ksCR+_lang Current("Using start date for calculation"); Current method name:C684; kFalse)
								$ld_dWorkStartDate:=ld_calc_adStart_Date{$ld_lWorkIndex}
								$ld_hWorkStartTime:=ld_calc_ahStart_Time{$ld_lWorkIndex}
							Else 
								//            ARRAY DATE(ld_calc_adPhaseCriticalStartDat;0)
								//            ARRAY LONGINT(ld_calc_ahPhaseCriticalStartTim;0)
								//            ARRAY DATE(ld_calc_adPhaseCriticalDate;0)  `PM: 2005-05-26
								//            ARRAY LONGINT(ld_calc_ahPhaseCriticalTime;0)  `PM: 2007-10-11
								//            ARRAY DATE(ld_calc_adPhaseCriticalExtraDat;0)  `PM: 2007-10-26
								//            ARRAY LONGINT(ld_calc_ahPhaseCriticalExtraTim;0)  `PM: 2007-10-26   
								
								If (ld_calc_adPhaseCriticalStartDat{$ld_lWorkIndex}#!00-00-00!)  //PM: 2009-02-12
									$ld_dWorkStartDate:=ld_calc_adPhaseCriticalStartDat{$ld_lWorkIndex}  //PM: 2009-02-12
									$ld_hWorkStartTime:=ld_calc_ahPhaseCriticalStartTim{$ld_lWorkIndex}  //PM: 2009-02-12
								Else 
									_err MESSAGE(_lang Current("Phase critical start date is zero for")+": "+ld_calc_asProduction_Lot__work_{$ld_lWorkIndex}+", "+ld_calc_atName{$ld_lWorkIndex}+"."+ksCR+_lang Current("Using start date for calculation"); Current method name:C684; kFalse)
									//         
									ldfl_rStartTimeTmp:=0
									//_dt ToReal (ld_calc_adStart_Date{$ld_lWorkIndex};ld_calc_ahStart_Time{$ld_lWor
									//~kIndex})
									ldfl_rEndTimeTmp:=0
									//FIX: ?24:00:00?
									$ld_rMovedDateTime:=_dt ToReal(ld_calc_adPhaseCriticalDate{$ld_lWorkIndex}; ?24:00:00?)
									$ld_rWorkTimeTotal:=ld_calc_arSetup_Time{$ld_lWorkIndex}+ld_calc_arWork_Time{$ld_lWorkIndex}  //+ld_calc_arExtra_Hours{$ld_lWorkIndex}
									//calculate from critical date end value backwards to new start time
									//extra time is already removed in critical date, so you MUST NOT  
									//add ld_calc_arExtra_Hours{$ld_lWorkIndex} to this $ld_rWorkTimeTotal
									ld_WORK_MOVE_CALCULATE(kFalse; $ld_tLoadGroup; $ld_rWorkTimeTotal; $ld_rMovedDateTime; ->ldfl_rStartTimeTmp; ->ldfl_rEndTimeTmp; ld_calc_asProduction_Lot__work_{$ld_lWorkIndex}; ld_calc_arLoadMultiplier{$ld_lWorkIndex})
									$ld_dWorkStartDate:=_dt RealToDate(ldfl_rStartTimeTmp)
									$ld_hWorkStartTime:=_dt RealToTime(ldfl_rStartTimeTmp)
								End if 
							End if 
						End if 
						
						$ld_lCapIndex:=ldcap_IndexFirst($ld_tLoadGroup; $ld_dWorkStartDate)
						$ld_rWorkTimeRemaining:=ld_calc_arSetup_Time{$ld_lWorkIndex}+ld_calc_arWork_Time{$ld_lWorkIndex}
						$ld_rWorkStart:=_dt ToReal($ld_dWorkStartDate; $ld_hWorkStartTime)
						While ($ld_rWorkTimeRemaining>0)
							$ld_rPhaseTimeRemaining:=_dt Difference(ldcap_arEnd{$ld_lCapIndex}; $ld_rWorkStart)
							$ld_rWorkTimeInPhaseMultiplier:=ldcap_PhaseTimeMultiplier($ld_lCapIndex; ld_calc_arLoadMultiplier{$ld_lWorkIndex}; $ld_tLoadGroup)
							$ld_rPhaseTimeRemaining:=$ld_rPhaseTimeRemaining*$ld_rWorkTimeInPhaseMultiplier
							Case of 
								: ($ld_rWorkTimeRemaining<=$ld_rPhaseTimeRemaining)
									ldcap_arCurrentFree{$ld_lCapIndex}:=ldcap_arCurrentFree{$ld_lCapIndex}-$ld_rWorkTimeRemaining
									$ld_rWorkTimeRemaining:=0  //end loop
								Else 
									//loop to next capacity        
									ldcap_arCurrentFree{$ld_lCapIndex}:=ldcap_arCurrentFree{$ld_lCapIndex}-$ld_rPhaseTimeRemaining
									$ld_rWorkTimeRemaining:=$ld_rWorkTimeRemaining-$ld_rPhaseTimeRemaining
									$ld_lCapIndex:=$ld_lCapIndex+1
									If ($ld_lCapIndex>$ldcap_lCapArrSize)
										$ld_tErr:=_lang Current(", load group: ")+$ld_tLoadGroup
										_err MESSAGE(_lang Current("Capacity not found, work remaining date date is bigger than capacity last date, ")+": "+ldcap_tCapacityName+$ld_tErr; Current method name:C684; kFalse)
										$ld_rWorkTimeRemaining:=0  //end loop
									Else 
										$ld_rWorkStart:=ldcap_arStart{$ld_lCapIndex}
									End if 
							End case 
						End while 
						
				End case 
		End case 
		
	End for 
	
	ldcap_arCurrentFree{0}:=0  //must be ZERO
	ldcap_arCumulativeFree{0}:=0  //must be ZERO
	
	If (<>ld_lCumulFreeFromCapacityStart=0)
		$ld_lCapFirst:=1
	End if 
	If ($ld_lCapFirst>0)  //calc first
		ldcap_arCumulativeFree{$ld_lCapFirst}:=ldcap_arCurrentFree{$ld_lCapFirst}
	End if 
	For ($ld_lCapIndex; $ld_lCapFirst+1; $ldcap_lCapArrSize)  //calc rest
		ldcap_arCumulativeFree{$ld_lCapIndex}:=ldcap_arCurrentFree{$ld_lCapIndex}+ldcap_arCumulativeFree{$ld_lCapIndex-1}
	End for 
	
End if 

If (<>_info_ fProfile)
	_info_ CALL_PROFILE(kStop; Current method name:C684)
End if 
